#ifndef _GETPKS_CPP
#define _GETPKS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../CSockSrvr/CSockSrvr.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Console.H"
#include "Replication.H"
#include "GetPKs.H"

#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetPrimaryKeysEx(CSQL *pcSQL, char *sTableName, LPPRIMARY_KEYS lpPKs)
{
	int iTempSz = 0;

	char sSQL[1024];
	char sPKCol[1024];
	char *sBaseSQL = NULL;

	bool bGetPKName = true;
	bool bRetVal = false;

	CRecordSet rsTemp;

	sBaseSQL = "SELECT SysObjects.name AS ConstraintName,  SysColumns.Name AS KeyColumn,"
		" SysTypes.Name as KeyColumnType,"
		" SysColumns.Length as KeyColumnLength, SysTypes.Status as TypeStatus"
		" FROM SysObjects, SysIndexes, SysTypes, SysIndexKeys, SysColumns"
		" WHERE SysObjects.xtype = 'PK' AND SysTypes.xType = SysColumns.xType"
		" AND SysObjects.Name = SysIndexes.Name AND SysIndexes.IndId = SysIndexKeys.IndId"
		" AND SysIndexes.ID = SysIndexKeys.ID AND SysIndexKeys.ColId = SysColumns.ColId"
		" AND SysObjects.Parent_Obj = SysColumns.ID AND SysObjects.Parent_Obj = Object_Id('%s')"
		" Order by SysIndexKeys.KeyNo";
	sprintf(sSQL, sBaseSQL, sTableName);

	if(!pcSQL->Execute(sSQL, &rsTemp))
	{
		return false;
	}

    strcpy(lpPKs->sPKTable, sTableName);

	if(rsTemp.RowCount > 0)
	{
		lpPKs->sPKs = (char **) calloc(sizeof(char *), rsTemp.RowCount + 1);
		lpPKs->sPKType = (char **) calloc(sizeof(char *), rsTemp.RowCount + 1);
		lpPKs->iPKLen = (int *) calloc(sizeof(int), rsTemp.RowCount + 1);
		lpPKs->iPKStatus = (int *) calloc(sizeof(int), rsTemp.RowCount + 1);

		lpPKs->iPKs = 0;

		while(rsTemp.Fetch())
		{
			iTempSz = 0;

			if(bGetPKName)
			{
				//Constraint Name.
				rsTemp.sColumnEx(1, lpPKs->sPKName, sizeof(lpPKs->sPKName), &iTempSz);
				bGetPKName = false;
			}

			//Key Column.
			rsTemp.sColumnEx(2, sPKCol, sizeof(sPKCol), &iTempSz);
			lpPKs->sPKs[lpPKs->iPKs] = (char *) calloc(sizeof(char), iTempSz + 1);
			strcpy(lpPKs->sPKs[lpPKs->iPKs], sPKCol);

			//Key Column Type.
			rsTemp.sColumnEx(3, sPKCol, sizeof(sPKCol), &iTempSz);
			lpPKs->sPKType[lpPKs->iPKs] = (char *) calloc(sizeof(char), iTempSz + 1);
			strcpy(lpPKs->sPKType[lpPKs->iPKs], sPKCol);

			//Key Column Length.
			lpPKs->iPKLen[lpPKs->iPKs] = rsTemp.lColumn(4);

			//Type Status.
			lpPKs->iPKStatus[lpPKs->iPKs] = rsTemp.lColumn(5);

			lpPKs->iPKs++;
		}
		bRetVal = true;
	}

	rsTemp.Close();

	return bRetVal;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreePrimaryKeysEx(LPPRIMARY_KEYS lpPKs)
{
	int iKey = 0;

	if(iKey < lpPKs->iPKs)
	{
		while(iKey < lpPKs->iPKs)
		{
			free(lpPKs->sPKs[iKey]);
			free(lpPKs->sPKType[iKey]);
			iKey++;
		}
	}

	free(lpPKs->sPKs);
	free(lpPKs->sPKType);
	free(lpPKs->iPKLen);
	free(lpPKs->iPKStatus);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
